#include "formulas.h"                                                           //fyzikální vztahy

#include "glob_prom.h"                                                          //globální proměnné
#include "numerics.h"                                                           //numerické metody
#include "postfix.h"                                                            //knihovna pro práci s postfixem
#include "operators.h"

void kontr_g (QString g[4][4])                                                  //výpočet kontravariantní metriky a překlad obou do kódu pro virtuální procesor
{
    QString o="*"; QString a=g[0][1]+g[0][1]+o; QString b=g[0][1]+g[0][2]+o;
    QString c=g[0][1]+g[0][3]+o; QString e=g[0][1]+g[2][3]+o;
    QString f=g[0][2]+g[0][2]+o; QString h=g[0][3]+g[0][3]+o;
    QString i=g[0][3]+g[1][2]+o; QString j=g[1][1]+g[2][2]+o;
    QString r=g[1][2]+g[1][2]+o; QString s=g[1][2]+g[1][3]+o;
    QString u=g[1][3]+g[1][3]+o; QString v=g[2][2]+g[3][3]+o; QString z="*+";
    QString w=g[2][3]+g[2][3]+o; QString k=v+w+'-'; QString q=j+r+'-';
    QString l=g[1][2]+g[3][3]+o+g[1][3]+g[2][3]+o+'-'; QString y="*-";
    QString m=g[1][1]+g[2][3]+o+s+'-'; QString p=g[1][1]+g[3][3]+o+u+'-';
    QString n=g[1][2]+g[2][3]+o+g[1][3]+g[2][2]+o+'-'; QString x="*-2";
    QString d=a+w+v+"-*"+g[0][0]+g[3][3]+j+r+"-*2"+g[2][3]+o+s+z+g[2][2]+u+y+
              g[1][1]+w+"*-*+2"+b+o+l+"*+2"+g[0][2]+o+g[0][3]+o+m+"*+2"+g[0][1]+
              o+g[0][3]+o+n+y+f+p+y+h+q+y;
    QString kon[4][4];
    kon[0][0]=k+g[1][1]+o+u+g[2][2]+x+s+o+g[2][3]+z+r+g[3][3]+y;
    kon[0][1]=k+'-'+g[0][1]+o+l+g[0][2]+z+n+g[0][3]+y;
    kon[0][2]=l+g[0][1]+o+p+g[0][2]+y+m+g[0][3]+z;
    kon[0][3]=n+'-'+g[0][1]+o+m+g[0][2]+z+q+g[0][3]+y;
    kon[1][1]=k+g[0][0]+o+h+g[2][2]+x+g[0][2]+o+g[0][3]+o+g[2][3]+z+f+g[3][3]+y;
    kon[1][2]=l+'-'+g[0][0]+o+e+g[0][2]+g[1][3]+o+'+'+g[0][3]+y+h+g[1][2]+z+
              b+g[3][3]+z;
    kon[1][3]=n+g[0][0]+o+e+i+'+'+g[0][2]+y+f+g[1][3]+z+c+g[2][2]+z;
    kon[2][2]=p+g[0][0]+o+h+g[1][1]+x+c+o+g[1][3]+z+a+g[3][3]+y;
    kon[2][3]=m+'-'+g[0][0]+o+i+g[0][1]+y+g[0][1]+g[1][3]+o+g[0][3]+g[1][1]+
              o+'-'+g[0][2]+y+a+g[2][3]+z;
    kon[3][3]=q+g[0][0]+o+f+g[1][1]+x+b+o+g[1][2]+z+a+g[2][2]+y;
    for (int a = 0; a < 4; ++a)
        for (int b = a; b < 4; ++b) {
            t.kov[a][b] = t.kov[b][a] = TrPfx(OptPfx(g[a][b]));                 //optimalizace a překlad kovariantního
            t.kon[a][b] = t.kon[b][a] = TrPfx(OptPfx(kon[a][b]));               //optimalizace a překlad kontravariantního
        }
    t.det = TrPfx(OptPfx(d));                                                   //optimalizace a překlad determinantu pro kontravariantní
}

void VnH()
{
    if (mink) {h1 = 2;} else {
        real a = P.M, b = oo, grr = 0;                                          //nastavení intervalu
        do {
            real x = (a + b) / 2;                                               //půlení intervalu
            real nrr = CntPfx(t.kov[1][1].n, {0,x,0,0});                        //výpočet g_{rr}
            if (nrr > grr) {b = x; grr = nrr;} else a = x;                      //když je nová hodnota větší  sniž horní mez intervalu, jinak zvyš dolní
        } while (grr < oo * oo);                                                //opakuj dokud nebude fakt velká
        h1 = b;
    }
    if (mink) {h2 = 0;} else {
        real a = 0, b = h1, grr = 0;                                            //nastavení intervalu
        int count = 0;
        do {
            real x = (a + b) / 2;                                               //půlení intervalu
            real nrr = CntPfx(t.kov[1][1].n, {0,x,0,0});                        //výpočet g_{rr}
            if (nrr > grr) {a = x; grr = nrr;} else b = x;                      //když je nová hodnota větší zvyš dolní mez intervalu, jinak sniž horní
            count++;
        } while (grr < oo * oo * oo && count < 2 * oo);                         //opakuj dokud nebude fakt velká, nebo příliš velký počet iterací
        h2 = b;
    }
    if (abs(h1 - h2) < ε){
        real a = P.M, b = oo, grr = 0;                                          //nastavení intervalu
        do {
            real x = (a + b) / 2;                                               //půlení intervalu
            real nrr = CntPfx(t.kov[1][1].n, {0,x,0,0});                        //výpočet g_{rr}
            if (nrr > grr) {b = x; grr = nrr;} else a = x;                      //když je nová hodnota větší  sniž horní mez intervalu, jinak zvyš dolní
        } while (grr < oo * oo);                                                //opakuj dokud nebude fakt velká
        h2 = b;
    }
}

real VneH()                                                                     //výběr vnějšího horizontu událostí
{
    return fmax(h1, h2);
}

real VniH()                                                                     //výběr vnitřního horizontu Cauchyho
{
    return fmin(h1, h2);
}

tensor_3 Christoffel(f_vec &x)                                                  //výpočet konexe
{
    tensor_3 result = {}, deri = {};
    real i[4][4] = {};
    const real det = CntPfx(t.det.n, x);                                        //předvýpočet determinantu pro kontravariantní tenzor
    for (int α = 0; α < 4; α++)                                                 //předvýpočet derivací
        for (int β = α; β < 4; β++) {
            if (t.kon[α][β].no[4])                                              //když není nulové
                i[β][α] = i[α][β] = CntPfx(t.kon[α][β].n, x) / det;             //vypočti g^{αβ}
            for (int γ = 0; γ < 4; γ++)
                if (t.kov[α][β].no[γ])                                          //když obsahuje proměnnou
                    deri(β, α, γ) = deri(α, β, γ) = der(t.kov[α][β].n, γ, x);   //derivuj podle ní
        }
    for (int β = 0; β < 4; β++)                                                 //výpočet christoffela
        for (int γ = 0; γ < 4; γ++)
            for (int δ = 0; δ < 4; δ++){
                real sum = (deri(δ, β, γ) + deri(δ, γ, β) - deri(β, γ, δ)) / 2;
                for (int α = 0; α < 4; α++)
                    result(α, β, γ) += i[α][δ] * sum;
            }
    return result;
}

f_vec dudλ(f_vec u, tensor_3 &christoffel)                                      //derivace rychlosti podle afinního parametru z rovnice geodetiky
{
    f_vec result = {};
    for (int β = 0; β < 4; β++)
        for (int γ = 0; γ < 4; γ++){
            real uk = u[β] * u[γ];
            for (int α = 0; α < 4; α++)
                result[α] -= christoffel(α, β, γ) * uk;                         //du^α/dλ = -Γ^α_βγ * u^β * u^γ
        }
    return result;
}

void tetrada(real (&e)[4][4], f_vec x)                                          //výpočet tetrády
{
    norm(e[0], x);
    for (int i = 1; i < 4; ++i) {
        for (int α = 0; α < 4; ++α) {
            for (int γ = 0; γ < 4; ++γ)
                for (int j = 0; j < i; ++j)
                    e[i][α] += CntPfx(t.kov[i][γ].n, x) * e[j][α] * e[j][γ];    //ortogonalizace projekčním tenzorem
            e[i][α] += (i == α);
        }
        norm(e[i], x);
    }
    ortonormalize(e, x);                                                        //Gram-Schmidtova zpřesňující ortogonalizace
}

f_vec transform(f_vec u, real (&e)[4][4])                                       //transformace vektoru maticí
{
    f_vec result = {};
    for (int α = 0; α < 4; ++α)
        for (int β = 0; β < 4; ++β)
            result[α] += u[β] * e[β][α];                                        //w^α = u^β * e^(α)_β
    return result;
}

f_vec t_tet(f_vec u, f_vec x)                                                   //převod z B-L souřadnic do LNRF tetrády
{
    real e[4][4]={};
    e[0][0] = 1;
    e[0][3] = -CntPfx(t.kov[0][3].n, x) / CntPfx(t.kov[3][3].n, x);             //(1,0,0,-g_{tφ}}/g_{φφ})
    tetrada(e, x);                                                              //výpočet tetrády
    invMatrix(e);                                                               //výpočet ω
    return transform(u, e);                                                     //u^a*ω_(a)
}

f_vec f_tet(f_vec u, f_vec x)                                                   //převod z LNRF tetrády do B-L souřadnic
{
    real e[4][4]={};
    e[0][0] = 1;
    e[0][3] = -CntPfx(t.kov[0][3].n, x) / CntPfx(t.kov[3][3].n, x);             //(1,0,0,-g_{tφ}}/g_{φφ})
    tetrada(e, x);                                                              //výpočet tetrády
    return transform(u, e);                                                     //u^a*e_(a)
}

f_vec f_tet(f_vec v, f_vec u, f_vec x)                                          //převod z souputující tetrády do B-L souřadnic
{
    real e[4][4]={};
    for (int i = 0; i < 4; ++i)
        e[0][i] = v[i];                                                         //e_(0) = v -> rychlost souputující tetrády
    tetrada(e, x);                                                              //výpočet tetrády
    return transform(u, e);                                                     //u^a*e_(a)
}

f_vec aberace(real α, real β, f_vec v, f_vec x)                                 //výpočet aberace
{
    real c = 2 / (α * α + β * β + 1);                                           //pohled z souputující tetrády
    return -f_tet(v, {1, c - 1, -β * c, -α * c}, x);
}

real rshft(f_vec u_e, f_vec v_e, f_vec x_e, f_vec u_o, f_vec v_o, f_vec x_o)    //dopplerův rudý posuv
{
    return fmin(dot_p(u_e.x, v_e.x, x_e),0)/fmin(dot_p(u_o.x, v_o.x, x_o),0)-1;
}

real beamg(f_vec u_e, f_vec v_e, f_vec x_e, f_vec u_o, f_vec v_o, f_vec x_o)    //relativistický beaming
{
    return
       fmin(pw(dot_p(u_o.x, v_o.x, x_o),3), 0) / pw(dot_p(u_e.x, v_e.x, x_e),3);
}

f_vec four_vt(real vk)                                                          //převod obvodové rychlosti na čtyřvektor
{
    real γ = 1 / sqrt(1 - vk * vk);
    return {γ, 0, 0, γ * vk};
}
