#include "geodetics.h"                                                          //výpočty geodetiky a pomocí geodetiky

#include <QImage>                                                               //knihovna pro práci s bitmapami
#include "formulas.h"                                                           //fyzikální vztahy
#include "glob_prom.h"                                                          //globální proměnné
#include "numerics.h"                                                           //numerické metody
#include "operators.h"                                                          //přetížení operátorů pro čtyřvektory

end::end(real vneh, real orb_lim)                                               //objekt hraničních stavů geodetiky
: vh(vneh), ol(orb_lim * π2), inf(oo)
{kep = ik = ok = a = 0; xp = {};};

end::~end(){};                                                                  //destruktor

void end::set_kepler(real &in_kepler, real &out_kepler)                         //nastavení rozměrů keplerova disku
{
    ik = in_kepler;                                                             //vnitřní poloměr
    ok = out_kepler;                                                            //vnější poloměr
};

bool end::exit(f_vec &x, f_vec &u)                                              //zda je geodetika na konci
{
    xa = x;
    if (xp[1]){                                                                 //když je aspoň jeden předchozí bod
        real dφ = xp[2] - xa[2];
        real dθ = xp[3] - xa[3];
        a += sqrt(dφ * dφ + dθ * dθ);                                           //integruje úhel
        if (kep < 3)
            if (((xp[2] - πp) * (xa[2] - πp)) <= 0) {                           //když protne equatoreální rovinu
                real eφ = xa[2] - xp[2];
                k[kep].r = (πp*(xa[1]-xp[1]) + xa[2]*xp[1] - xa[1]*xp[2]) / eφ; //kde
                k[kep].φ = (πp*(xa[3]-xp[3]) + xa[2]*xp[3] - xa[3]*xp[2]) / eφ;
                uf[kep] = u;                                                    //jakým směrem
                if (ik < k[kep].r && k[kep].r < ok) kep++;                      //když protne akreční disk
            }
    };
    xp = xa;
    return vh < xa[1] && xa[1] < inf && a < ol;                                 //když spadl, nebo unikl, nebo limitně obíhal
};

char end::reason()                                                              //co přitom zažila
{
    char result = 0;
    if (xa[1] >= inf) result = 1;                                               //skončila v nekonečnu
    if (xa[1] <= vh) result = 2;                                                //skončila pod horizontem
    if (a >= ol) result = 3;                                                    //udělala moc oběhů
    if (kep > 0) result *= -1;                                                  //když přitom prošla akrečním diskem
    return result;
};

real end::evhor(){return vh;}

polar end::k_loc(int i){return k[i];};                                          //vrací kde protla akreční disk

f_vec end::k_vel(int i){return uf[i];};                                         //vrací jaký měla směr

int end::kkp(){return kep;}                                                     //kolikrát protl keplera

void geodetika(f_vec &x, f_vec &u, end &end, real prec, geo *g)                 //geodetika s možným záznamem trasy
{
    do {
        real step = fmax(10+100/(prec*(end.evhor()-x[1])*sin(x[2])-10),prec/50);//adaptivní krok
        u = rungekuta(dudλ, u, Christoffel(x), step);                           //výpočet vektoru rychlosti
        x = x + u * step;                                                       //výpočet vektoru polohy
        if (g) g->insert(x, u);                                                 //záznam trasy
    } while (end.exit(x, u) && !stop);                                          //testování konce geodetiky
}

uint32_t GetColor(real α, real β, f_vec x, f_vec v)
{
    uint32_t col = 0xff000000;                                                  //proměnná výsledné barvy
    real dα = 0, dβ = 0;                                                        //centrování aberace nulové
    end end(VneH() * (1 + precise * 0.03), 15);                                 //hraniční podmínky geodetiky
    if (kepler) end.set_kepler(P.i, P.o);                                       //když je akreční disk, nastavení jeho rozměrů
    if (el_ab) {                                                                //eliminace aberace - jen posun, zkreslení zůstává
        f_vec s = {-1,-1,0,0};
        f_vec t = t_tet(aberace(0, 0, v, x),x);
        dβ = cos(atan(t[3] / t[2])) * acos(s * t / sqrt(t * t)) / 2;
        dα = sin(atan(t[3] / t[2])) * acos(s * t / sqrt(t * t)) / 2;
    };
    f_vec u = aberace(α + dα, β + dβ, v, x);                                    //aberace od pohybu pozorovatele
    f_vec u_p = u, v_p = v, x_p = x;                                            //uložení stavu pozorovatele a jeho pohledu
    geodetika(x, u, end, precise);                                              //výpočet geodetiky
    if (abs(end.reason()) > 1) col = 0xff000000;                                //když skončila pod horizontem nebo ve smyčkách, tak černo
    if (abs(end.reason()) == 1) {                                               //když skončila v nekonečnu
        if (b_gnd.isNull())                                                     //když není načtená bitmapa pozadí, tak zelená šachovnice
            col = 0x0088ff88 * (sin(x[2]*18) * cos(x[3]*18) <= 0) + 0xff000000;
        else                                                                    //jinak se přečte barva z pozadí
            col = b_gnd.pixel(b_gnd.width() * fmod(π2 + fmod(-x[3], π2),π2) / π2
                             ,b_gnd.height() * fmod(π + fmod(x[2], π), π) / π);
        if (shift) col = sh_col(col, rshft(-u, {1,0,0,0}, x, -u_p, v_p, x_p));  //posune se redshiftem
        if (beam)  col = bm_col(col, beamg(-u, {1,0,0,0}, x, -u_p, v_p, x_p));  //a zjasní beamingem
    };
    if (end.reason() < 0) {                                                     //když proletěl akrečním diskem
        for (int i = end.kkp() - 1; i > -1; --i) {                              //i-tý průlet
            real r = end.k_loc(i).r;                                            //radiální souřadnice průsečíku paprsku s keplerovým diskem
            real φ = end.k_loc(i).φ;                                            //azimutální souřadnice průsečíku paprsku s keplerovým diskem
            real rr = (r - P.i) / (P.o - P.i);                                  //jednotková vzdálenost od horizontu
            φ -= φ_spd[int(64 * rr)] * x_p[0];                                  //roztočení akrečního disku v pásech, aby se detaily zobrazující pohyb nerozmíchaly
            real x_ = rr * sin(φ);                                              //vodorovná souřadnice pixelu ve snímku akrečního disku
            real y_ = rr * cos(φ);                                              //svislá souřadnice pixelu ve snímku akrečního disku
            uint32_t kep =acr.pixel((1+x_)*acr.width()/2,(1+y_)*acr.height()/2);//barva pixelu na souřadnicích x,y ze snímku akrečního disku
            if (shift || beam) {                                                //vykoná se pokud je zvolena volba výpočtu redshiftu
                f_vec pk = {0, r, πp, φ};                                       //souřadnice průsečíku akrečního disku s paprskem v Boyer-Lindquistových souřadnicích
                f_vec uz = f_tet(four_vt(o_spd[int(512 * rr)]),pk);             //rychlost zdroje v keplerovi
                if (shift)
                    kep = sh_col(kep, rshft(-end.k_vel(i),uz,pk,-u_p,v_p,x_p)); //výpočet redshiftu ve směru fotonu a rychlosti disku v v místě pk posun barvy redshiftem
                if (beam) 
                    kep = bm_col(kep, beamg(-end.k_vel(i),uz,pk,-u_p,v_p,x_p)); //výpočet beamingu ve směru fotonu a rychlosti disku v v místě pk zjasnění beamingen
            };
            col = av_col(col, kep);                                             //vážený průměr barvy akrečního disku a pozadí (je lehce průhledný)
        };
    };
    return col;
}

real OrbSpeed(f_vec sp, int dir)                                                //výpočet kruhové rychlosti
{
    real va = 0, vb = dir, v;                                                   //meze odhadu rychlosti
    do {
        v = (va + vb) / 2;                                                      //půlení intervalu
        if (rungekuta(dudλ,f_tet(four_vt(v), sp), Christoffel(sp), ε)[1] > 0)   //test r složky rychlosti na nulu
            vb = v; else va = v;
    } while (abs(vb - va) > ε);                                                 //když je dosaženo požadované přesnosti tak konec
    return v;
}

void O_Speed(real in, real out)                                                 //předvýpočet obvodových rychlostí keplerova disku
{                                                                               //v lnrf
    for (int i = 0; i < 512; ++i) {
        f_vec x = {0,in + i * (out - in) / 512, πp, 0};
        o_spd[i] = OrbSpeed(x, 1);
    }
    for (int i = 0; i < 64; ++i) {
        f_vec x = {0,in + i * (out - in) / 64, πp, 0};
        φ_spd[i] = f_tet(four_vt(o_spd[i * 4]),x)[3];
    }
}

real lim_stab_orb(int dir)                                                      //výpočet mezní stabilní orbity
{
    int count = 20;
    real vneh = VneH();                                                         //horizont událostí
    real xa = vneh, xb = 20 * xa;                                               //interval od horizontu do nekonečna pro bisekci
    do {
        real xp = (xb + xa) / 2;
        real step = xp * 0.03;
        f_vec xk = {0, xp, πp, 0};
        real v = OrbSpeed(xk, dir);                                             //výpočet kruhové rychlosti
        f_vec vk = f_tet(four_vt(v), xk);
        end end(vneh, 25);                                                      //koncové podmínky geodetiky - 15 obletů
        geodetika(xk, vk, end, step);
        if (vk[1] * vk[1] < ε * step) xb = xp; else xa = xp;                    //test na nulovou radiální rychlost
        count--;
    } while (xb - xa > ε && count > 0);                                         //když je dosaženo požadované přesnosti tak konec
    return xa;
}
