#ifndef GEODETICS_H
#define GEODETICS_H

#include "struktury.h"                                                          //komplexnější proměnné a objekty

class end                                                                       //objekt hraničních stavů geodetiky
{
public:
    end(real vneh, real orb_lim);                                               //konstruktor
    ~end();                                                                     //destruktor
    bool exit(f_vec &x, f_vec &u);                                              //zda je geodetika na konci
    char reason();                                                              //a co přitom zažila
    real evhor();                                                               //vrací vneh funkci, do které vstoupí
    polar k_loc(int i);                                                         //kde protla akreční disk
    f_vec k_vel(int i);                                                         //a jaký měla směr
    int kkp();                                                                  //kolikrát protl keplera
    void set_kepler(real &in_kepler, real &out_kepler);                         //nastavení rozměrů keplerova disku
private:
    f_vec xp, xa, uf[3];
    real a, ik, ok, vh, ol, inf;
    polar k[3];
    int kep;
};

void geodetika(f_vec &x, f_vec &u, end &end, real prec, geo *g = nullptr);      //geodetika s možným záznamem trasy
uint32_t GetColor(real, real, f_vec x, f_vec v);                                //barva kam geodetika došla
real OrbSpeed(f_vec sp, int dir);                                               //výpočet kruhové rychlosti
void O_Speed(real in, real out);                                                //předvýpočet orbitálních rychlostí akrečního disku
real lim_stab_orb(int dir);                                                     //výpočet mezní stabilní orbity

#endif // GEODETICS_H
