#include "mainwindow.h"
#include "./ui_mainwindow.h"

#include <QFileDialog>                                                          //knihovna pro GUI práce se soubory
#include <QPainter>                                                             //knihovna pro práci s bitmapou
#include "formulas.h"                                                           //fyzikální vzorečky
#include "geodetics.h"                                                          //výpočty geodetiky a pomocí geodetiky
#include "glob_prom.h"                                                          //globální proměnné
#include "numerics.h"                                                           //numerické metody
#include "postfix.h"                                                            //práce s posfixem
#include "image_generate.h"                                                     //výpočet bitmapy snímku
#include "avi/QAviWriter.h"                                                     //knihovna pro uložení AVI

MainWindow::MainWindow(QWidget *parent) :
            QMainWindow(parent), ui(new Ui::MainWindow)                         //(konstruktor)
{
    inicialize();                                                               //inicializace globálních proměnných
    acr.load(":/kepler.png");                                                   //načtení obrazu akrečního disku
    ui->setupUi(this);                                                          //zobrazení okna
    ui->tabWidget->setCurrentIndex(0);                                          //nastavení aktivní první záložky
    ui->radButn4->setChecked(true);                                             //volba Kerrovy metriky
    ui->checkBox_anim->setChecked(false);                                       //výchozí vypnutí animace
    ui->widget_anim->setEnabled(ui->checkBox_anim->isChecked());                //a políček jeho nastavení
}

MainWindow::~MainWindow() {delete ui;}                                          //zavření okna (destruktor)

void MainWindow::resizeEvent(QResizeEvent *event)                               //když je aktivní tab s geodetikou  - při změně velikosti i překreslit geodetiku
{
    QWidget::resizeEvent(event);
    if (ui->tabWidget->currentIndex() == 1) draw_geodetics();
}

QString MainWindow::corect(QString text)                                        //vkládání řeckých symbolů
{
    text.replace('t',u'θ');                                                     //při napsání t nahraď theta
    text.replace('f',u'φ');                                                     //při napsání f nahraď fí
    text.replace('l',u'Λ');                                                     //při napsání l nahraď lambda
    text.replace('m',u'M');                                                     //při napsání m nahraď velkým
    text.replace('q',u'Q');                                                     //při napsání q nahraď velkým
    return text;
}

void MainWindow::reload()                                                       //načteni všech vstupů
{
    QString g[4][4] = {
        {ToPfx(ui->tt->text()), ToPfx(ui->tr->text()),
         ToPfx(ui->te->text()), ToPfx(ui->tf->text())},
        {ToPfx(ui->rt->text()), ToPfx(ui->rr->text()),
         ToPfx(ui->re->text()), ToPfx(ui->rf->text())},
        {ToPfx(ui->et->text()), ToPfx(ui->er->text()),
         ToPfx(ui->ee->text()), ToPfx(ui->ef->text())},
        {ToPfx(ui->ft->text()), ToPfx(ui->fr->text()),
         ToPfx(ui->fe->text()), ToPfx(ui->ff->text())}                          //načtení políček metriky do matice g
    };
    kontr_g(g);                                                                 //výpočet kontravariantního tenzoru, optimalizace a překlad na vnitřní kód

    P.M = ui->lineEdit_M   ->text().toDouble();
    P.a = ui->lineEdit_a   ->text().toDouble();
    P.Q = ui->lineEdit_Q   ->text().toDouble();
    P.Λ = ui->lineEdit_L   ->text().toDouble();
    P.o = ui->lineEdit_outK->text().toDouble();                                 //načtení parametrů

    precise = ui->cBox_precise->currentText().toFloat();                        //načtení přesnosti výpočtu
    poc_sour_poz[1] = ui->lineEdit_r->text().toFloat();                         //načtení počátečních podmínek
    poc_sour_poz[2] = π * ui->lineEdit_th->text().toFloat() / 180;

    P.i = 1;

    if (mink) {
        ui->lineEdit_VneH->setText("");
        ui->lineEdit_VniH->setText("");
        ui->lineEdit_RSO->setText("");
        ui->lineEdit_inK->setText("");
        ui->lineEdit_LSO->setText("");
    } else {
        VnH();
        P.i = lim_stab_orb(1);
        ui->lineEdit_VneH->setText(QString::number(double(VneH())));            //výpočet základních charakteristik - vnější horizont
        ui->lineEdit_VniH->setText(QString::number(double(VniH())));            //vnitřní horizont
        ui->lineEdit_RSO->setText(QString::number(double(lim_stab_orb(1))));    //pravotočivá ISCO
        ui->lineEdit_inK->setText(QString::number(double(lim_stab_orb(1))));    //vnitřní poloměr keplera na pravotočivou ISCO
        ui->lineEdit_LSO->setText(QString::number(double(lim_stab_orb(-1))));   //levotočivá ISCO
        emit ui->lineEdit_r->editingFinished();
    }
}

void MainWindow::pre_v()                                                        //výpočet kruhové rychlosti
{
    if (mink) ui->lineEdit_v->setText(""); else
     ui->lineEdit_v->setText(QString::number(double(OrbSpeed(poc_sour_poz,1))));
}

void MainWindow::on_tt_editingFinished() {reload();}                            //editace políček metriky
void MainWindow::on_tr_editingFinished() {reload();}
void MainWindow::on_te_editingFinished() {reload();}
void MainWindow::on_tf_editingFinished() {reload();}
void MainWindow::on_rt_editingFinished() {reload();}
void MainWindow::on_rr_editingFinished() {reload();}
void MainWindow::on_re_editingFinished() {reload();}
void MainWindow::on_rf_editingFinished() {reload();}
void MainWindow::on_et_editingFinished() {reload();}
void MainWindow::on_er_editingFinished() {reload();}
void MainWindow::on_ee_editingFinished() {reload();}
void MainWindow::on_ef_editingFinished() {reload();}
void MainWindow::on_ft_editingFinished() {reload();}
void MainWindow::on_fr_editingFinished() {reload();}
void MainWindow::on_fe_editingFinished() {reload();}
void MainWindow::on_ff_editingFinished() {reload();}

void MainWindow::on_tt_textEdited(const QString &arg1)                          //oprava políček metriky
{ui->tt->setText(corect(arg1));}
void MainWindow::on_tr_textEdited(const QString &arg1)
{ui->tr->setText(corect(arg1));}
void MainWindow::on_te_textEdited(const QString &arg1)
{ui->te->setText(corect(arg1));}
void MainWindow::on_tf_textEdited(const QString &arg1)
{ui->tf->setText(corect(arg1));}
void MainWindow::on_rt_textEdited(const QString &arg1)
{ui->rt->setText(corect(arg1));}
void MainWindow::on_rr_textEdited(const QString &arg1)
{ui->rr->setText(corect(arg1));}
void MainWindow::on_re_textEdited(const QString &arg1)
{ui->re->setText(corect(arg1));}
void MainWindow::on_rf_textEdited(const QString &arg1)
{ui->rf->setText(corect(arg1));}
void MainWindow::on_et_textEdited(const QString &arg1)
{ui->et->setText(corect(arg1));}
void MainWindow::on_er_textEdited(const QString &arg1)
{ui->er->setText(corect(arg1));}
void MainWindow::on_ee_textEdited(const QString &arg1)
{ui->ee->setText(corect(arg1));}
void MainWindow::on_ef_textEdited(const QString &arg1)
{ui->ef->setText(corect(arg1));}
void MainWindow::on_ft_textEdited(const QString &arg1)
{ui->ft->setText(corect(arg1));}
void MainWindow::on_fr_textEdited(const QString &arg1)
{ui->fr->setText(corect(arg1));}
void MainWindow::on_fe_textEdited(const QString &arg1)
{ui->fe->setText(corect(arg1));}
void MainWindow::on_ff_textEdited(const QString &arg1)
{ui->ff->setText(corect(arg1));}

void MainWindow::on_radButn1_toggled(bool checked)                              //minkovského (rovná) metrika
{
    if (checked){
        mink = true;
        ui->tt->setText("-1");
        ui->tr->setText("0");
        ui->te->setText("0");
        ui->tf->setText("0");
        ui->rt->setText("0");
        ui->rr->setText("1");
        ui->re->setText("0");
        ui->rf->setText("0");
        ui->et->setText("0");
        ui->er->setText("0");
        ui->ee->setText("r^2");
        ui->ef->setText("0");
        ui->ft->setText("0");
        ui->fr->setText("0");
        ui->fe->setText("0");
        ui->ff->setText("r^2*sin(θ)^2");
        ui->lineEdit_a->setText("0"); ui->lineEdit_Q->setText("0"); reload();
    }
}

void MainWindow::on_radButn2_toggled(bool checked)                              //schwarzschildova metrika
{
    if (checked){
        mink = false;
        ui->tt->setText("-(1-2*M/r)");
        ui->tr->setText("0");
        ui->te->setText("0");
        ui->tf->setText("0");
        ui->rt->setText("0");
        ui->rr->setText("1/(1-2*M/r)");
        ui->re->setText("0");
        ui->rf->setText("0");
        ui->et->setText("0");
        ui->er->setText("0");
        ui->ee->setText("r^2"); ui->ef->setText("0");
        ui->ft->setText("0");
        ui->fr->setText("0");
        ui->fe->setText("0");
        ui->ff->setText("r^2*sin(θ)^2");
        ui->lineEdit_a->setText("0"); ui->lineEdit_Q->setText("0"); reload();
    }
}

void MainWindow::on_radButn3_toggled(bool checked)                              //raisner-nordstrom metrika
{
    if (checked){
        mink = false;
        ui->tt->setText("-((Q^2-2*M*r+r^2)/r^2)");
        ui->tr->setText("0");
        ui->te->setText("0");
        ui->tf->setText("0");
        ui->rt->setText("0");
        ui->rr->setText("r^2/(Q^2-2*M*r+r^2)");
        ui->re->setText("0");
        ui->rf->setText("0");
        ui->et->setText("0");
        ui->er->setText("0");
        ui->ee->setText("r^2");
        ui->ef->setText("0");
        ui->ft->setText("0");
        ui->fr->setText("0");
        ui->fe->setText("0");
        ui->ff->setText("r^2*sin(θ)^2");
        ui->lineEdit_a->setText("0"); ui->lineEdit_Q->setText("0.1"); reload();
    }
}

void MainWindow::on_radButn4_toggled(bool checked)                              //kerrova metrika
{
    if (checked){
        mink = false;
        ui->tt->setText("-1+(2*M*r)/(r^2+a^2*cos(θ)^2)");
        ui->tr->setText("0");
        ui->te->setText("0");
        ui->tf->setText("-((2*a*M*r*sin(θ)^2)/(r^2+a^2*cos(θ)^2))");
        ui->rt->setText("0");
        ui->rr->setText("(r^2+a^2*cos(θ)^2)/(a^2-2*M*r+r^2)");
        ui->re->setText("0");
        ui->rf->setText("0");
        ui->et->setText("0");
        ui->er->setText("0");
        ui->ee->setText("r^2+a^2*cos(θ)^2");
        ui->ef->setText("0");
        ui->ft->setText("-((2*a*M*r*sin(θ)^2)/(r^2+a^2*cos(θ)^2))");
        ui->fr->setText("0");
        ui->fe->setText("0");
        ui->ff->setText("sin(θ)^2*(a^2+r^2+(2*a^2*M*r*sin(θ)^2)/(r^2+a^2*cos(θ)^2))");
        ui->lineEdit_a->setText("0.8"); ui->lineEdit_Q->setText("0"); reload();
    }
}

void MainWindow::on_radButn5_toggled(bool checked)                              //kerr-newmanova metrika
{
    if (checked){
        mink = false;
        ui->tt->setText("-1-(Q^2-2*M*r)/(r^2+a^2*cos(θ)^2)");
        ui->tr->setText("0");
        ui->te->setText("0");
        ui->tf->setText("(a*(Q^2-2*M*r)*sin(θ)^2)/(r^2+a^2*cos(θ)^2)");
        ui->rt->setText("0");
        ui->rr->setText("(r^2+a^2*cos(θ)^2)/(a^2+Q^2-2*M*r+r^2)");
        ui->re->setText("0");
        ui->rf->setText("0");
        ui->et->setText("0");
        ui->er->setText("0");
        ui->ee->setText("r^2+a^2*cos(θ)^2");
        ui->ef->setText("0");
        ui->ft->setText("(a*(Q^2-2*M*r)*sin(θ)^2)/(r^2+a^2*cos(θ)^2)");
        ui->fr->setText("0");
        ui->fe->setText("0");
        ui->ff->setText("sin(θ)^2*(a^2+r^2-(a^2*(Q^2-2*M*r)*sin(θ)^2)/(r^2+a^2*cos(θ)^2))");
        ui->lineEdit_a->setText("0.8"); ui->lineEdit_Q->setText("0.1"); reload();
    }
}

void MainWindow::on_lineEdit_a_editingFinished() {reload();}                    //načtení spinu

void MainWindow::on_lineEdit_M_editingFinished() {reload();}                    //načení hmotnosti

void MainWindow::on_lineEdit_Q_editingFinished() {reload();}                    //načtení náboje

void MainWindow::on_lineEdit_L_editingFinished() {reload();}                    //načtení kosmologické konstanty

void MainWindow::on_lineEdit_inK_editingFinished()                              //načtení vnitřního poloměru keplerova disku
{
    P.i = ui->lineEdit_inK->text().toFloat();
    if (P.i < P.o) O_Speed(P.i, P.o);
}

void MainWindow::on_lineEdit_outK_editingFinished()                             //načtení vnějšího poloměru keplerova disku
{
    P.o = ui->lineEdit_outK->text().toFloat();
    if (P.i < P.o) O_Speed(P.i, P.o);
}

void MainWindow::on_lineEdit_r_editingFinished()                                //načtení radiální vzdálenosti pozorovatele
{poc_sour_poz[1] = ui->lineEdit_r->text().toFloat(); pre_v();}

void MainWindow::on_lineEdit_th_editingFinished()                               //načtení polární vzdálenosti pozorovatele
{poc_sour_poz[2] = π * ui->lineEdit_th->text().toFloat() / 180; pre_v();}

void MainWindow::on_lineEdit_v_textChanged(const QString &arg1)                 //načtení počáteční rychlosti pozorovatele
{ui->spinBox_v->setValue(ui->lineEdit_v->text().toDouble());}

void MainWindow::on_cBox_precise_currentTextChanged(const QString &arg1)        //načtení přesnosti výpočtu
{precise = ui->cBox_precise->currentText().toFloat();}

void MainWindow::on_lineEdit_VneH_textChanged(const QString &arg1)              //zajištění nezměnitelnosti vypočtené hodnoty vnějšího horizontu
{ui->lineEdit_VneH->setText(QString::number(double(VneH())));}

void MainWindow::on_lineEdit_VniH_textChanged(const QString &arg1)              //zajištění nezměnitelnosti vypočtené hodnoty vnitřního horizontu
{ui->lineEdit_VniH->setText(QString::number(double(VniH())));}

void MainWindow::on_lineEdit_RSO_editingFinished()                              //zajištění nezměnitelnosti vypočtené hodnoty pravostranné ISCO
{ui->lineEdit_RSO->setText(QString::number(double(lim_stab_orb(1))));}

void MainWindow::on_lineEdit_LSO_editingFinished()                              //zajištění nezměnitelnosti vypočtené hodnoty levostranné ISCO
{ui->lineEdit_LSO->setText(QString::number(double(lim_stab_orb(-1))));}

void MainWindow::on_verticalSlider_sliderReleased() {                           //změna zorného pole
    emit ui->StopButton->clicked();                                             //zastavení probíhajícího výpočtu
    QCoreApplication::processEvents(QEventLoop::AllEvents);                     //prostor pro reakci GUI (tady tlačítka stop)
}

void MainWindow::on_PlayButton_clicked() {                                      //spuštění výpočtu
    stop = false;                                                               //globální příznak stop zastaví všechny probíhající výpočty kdekoli v jakémkoli vlákně
    ui-> StopButton->setEnabled(true);                                          //vypnutí play tlačítka
    ui->PlayButton->setEnabled(false);                                          //zapnutí stop tlačítka
    switch (ui->cBox_res->currentIndex()) {                                     //volba rozlišení výpočtu
    case 0: MainWindow::recomp(160, 120); break;
    case 1: MainWindow::recomp(320, 240); break;
    case 2: MainWindow::recomp(800, 600); break;
    case 3: MainWindow::recomp(1024, 768); break;
    case 4: MainWindow::recomp(1280, 960); break;
    case 5: MainWindow::recomp(2048, 1536); break;
    case 6: MainWindow::recomp(4096, 3072); break;
    default: break;
    }
}

void MainWindow::on_StopButton_clicked()                                        //předčasné ukončení výpočtu
{do {stop = true;} while (!stop); ui->StopButton->setEnabled(false);}           //vynucené čekání ve smyčce dokud se stop skutečně nezmění

void MainWindow::on_checkBox_anim_stateChanged(int arg1)                        //volba animace
{ui->widget_anim->setEnabled(ui->checkBox_anim->isChecked());}

void MainWindow::on_spinBox_v_valueChanged(double arg1)                         //překreslení geodetiky při změně rychlosti
{ui->lineEdit_v->setText(ui->spinBox_v->text()); draw_geodetics();}

void MainWindow::on_spinBox_round_valueChanged(double arg1) {draw_geodetics();} //překreslení geodetiky při změně počtu oběhů

void MainWindow::on_tabWidget_currentChanged(int index)                         //vykreslení geodetiky při volbě její záložky
{if (ui->tabWidget->currentIndex() == 1) draw_geodetics();}

void MainWindow::on_horizontalSlider_sliderMoved(int position)                  //zobrazení vypočteného snímku animace podle pozice šoupátka
{
    int w = image[position].width();
    int h = image[position].height();
    QPixmap pixmap(w,h);
    pixmap.convertFromImage(raw_to_image(image[position],w,h));
    pixmap = pixmap.scaled(w, h,Qt::IgnoreAspectRatio,Qt::SmoothTransformation);
    ui->label_screen->setPixmap(addTxtImg(pixmap.scaled(ui->label_screen->size()
    ,Qt::KeepAspectRatioByExpanding,Qt::SmoothTransformation),image[position]));
}

void MainWindow::on_checkBox_kepler_toggled(bool checked)                       //vygenerování obvodových rychlostí keplerova disku
{if (checked && (o_spd[0] == 0)) O_Speed(P.i, P.o);}

void MainWindow::on_checkBox_sour_toggled(bool checked)
{sour = checked;}

void MainWindow::on_comboBox_transp_currentIndexChanged(int index)              //nastavení průhlednosti keplerova disku
{
    switch (index) {
        case 0: transp = 1; break;
        case 1: transp = 2; break;
        case 2: transp = 5; break;
        case 3: transp = 9; break;
        case 4: transp = 65535; break;
    }
}

void MainWindow::on_OpenImageButton_clicked()                                   //Načtení panoramatického snímku pozadí
{
    b_gnd.load(QFileDialog::getOpenFileName(this, tr("Open Image"),
        QDir::homePath() + "/Desktop", tr("Image Files (*.png *.jpg *.bmp)")));
}

void MainWindow::on_SaveImageButton_clicked()                                   //uložení vypočteného snímku
{
    addTxtImg(raw_to_image(image[frame],image[frame].width(),
    image[frame].height()), image[frame]).
    save(QFileDialog::getSaveFileName(this, tr("Save Image"),
    QDir::homePath() + "/Desktop/hole.jpg",
    tr("Image Files (*.jpg *.png *.bmp)")), nullptr, 100);
}

void MainWindow::on_saveVideoButton_clicked()                                   //uložení vypočtené animace
{
    int frames = ui->comboBox_Frames->currentText().toInt();
    if (ui->comboBox_FVid->currentIndex() == 1) {                               //jako sekvence snímků
        QString path = QFileDialog::getSaveFileName(this, tr("Save Image"),
            QDir::homePath()+"/Desktop/hole.jpg", tr("Image Files (*.jpg)"));
        for (int f = 0; f < frames; ++f)
            addTxtImg(raw_to_image(image[f], image[0].width(),
                image[0].height()), image[f]).save(path.chopped(4).
                append(QString::number(f)).append(".jpg"), nullptr, 100);
    } else {                                                                    //jako AVI
        QString path = QFileDialog::getSaveFileName(this, tr("Save Image"),
               QDir::homePath()+"/Desktop/hole.avi", tr("Image Files (*.avi)"));
        QAviWriter writer(path,QSize(image[0].width(), image[0].height()),
            ui->comboBox_FrameRate->currentText().toInt(),"MJPG");
        writer.open();
        for (int f = 0; f < frames; ++f)
            if (image[f].width() > 1)
                writer.addFrame(addTxtImg(raw_to_image(image[f],
                image[0].width(), image[0].height()), image[f]), "JPG",100);
        writer.close();
    }
}

void MainWindow::recomp(int width, int height)                                  //výpočet snímku, nebo sekvence
{
    ui->tab_param->setEnabled(false);                                           //zablokování všech ostatních záložek
    ui->tab_settings->setEnabled(false);
    ui->tab_geodetics->setEnabled(false);
    ui->horizontalSlider->setEnabled(false);

    int frames;
    geo g; end end(VneH() * (1 + precise * 0.03), ui->spinBox_round->value());  //objekt hraničních podmínek geodetiky
    f_vec sp = {0,ui->lineEdit_r->text().toFloat(),                             //souřadnice pozorovatele
                real(ui->lineEdit_th->text().toFloat() * π / 180.0),0};
    f_vec vp = f_tet(four_vt(ui->lineEdit_v->text().toFloat()), sp);            //rychlost pozorovatele
    if (ui->checkBox_anim->isChecked())
        frames = ui->comboBox_Frames->currentText().toInt();                    //načtení počtu snímků
    else frames = 1;
    geodetika(sp, vp, end, precise / 10, &g);                                   //výpočet bodů geodetiky pozorovatele do objektu g
    ui->horizontalSlider->setMaximum(frames - 1);                               //nastavení dělení posuvníku
    for (frame = 0; frame < frames; ++frame) {                                  //výpočet pohledu z místa geodetiky
        int i =  frame * g.getCount() / frames;
        ui->horizontalSlider->setValue(frame);                                  //posun šoupátka posuvníku (nyní slouží jako ukazatel stavu výpočtu)
        qint64 t = Compute(g.getX(i), g.getV(i), width, height,
                    πp / ui->verticalSlider->value(), ui);
        ui->lab_est_time->setText(to_time(t * 60));
        ui->lab_tot_time->setText(to_time((frames - frame - 1) * t));           //Compute vypočte snímek a vrací čas potřebný na výpočet jednoho snímku
    }
    if (frames == 1) frame = 0;                                                 //když nejde o sekvenci, ale jen jeden snímek
    stop = false;

    ui->StopButton->setEnabled(false);
    ui->PlayButton->setEnabled(true);
    ui->tab_param->setEnabled(true);                                            //odblokování ostatních záložek
    ui->tab_settings->setEnabled(true);
    ui->tab_geodetics->setEnabled(true);
    ui->horizontalSlider->setEnabled(true);
}

void MainWindow::draw_geodetics()                                               //vykreslení geodetiky pozorovatele
{
    int w = ui->label_geo->width() - 2, h = ui->label_geo->height() - 2;
    real vh = VneH() * (1 + precise * 0.03), e_x = 0, e_y = 0, z;
    geo g; end end(vh, ui->spinBox_round->value());                             //objekt hraničních podmínek geodetiky
    f_vec sp = {0,ui->lineEdit_r->text().toFloat(),                             //souřadnice pozorovatele
                real(ui->lineEdit_th->text().toFloat() * π / 180.0),0};
    f_vec vp = f_tet(four_vt(ui->lineEdit_v->text().toFloat()), sp);            //rychlost pozorovatele
    geodetika(sp, vp, end, precise / 4, &g);                                    //výpočet bodů geodetiky pozorovatele do třídy g
    for (int i = 0; i < g.getCount(); ++i) {                                    //detekce rozměrů geodetiky
        e_x = fmax(e_x,abs(g.getX(i)[1]*cos(g.getX(i)[3])*sin(g.getX(i)[2])));
        e_y = fmax(e_y,abs(g.getX(i)[1]*sin(g.getX(i)[3])*sin(g.getX(i)[2])));
    }
    z = fmin(h / e_y, w / e_x) / 2;
    ui->label_geopoint->setText(QString::number(g.getCount()));                 //vykreslení geodetiky
    QPixmap pixmap(w, h);
    pixmap.fill(Qt::gray);
    QPainter painter(&pixmap);
    painter.setBrush(QBrush(Qt::black));
    painter.drawEllipse(w / 2 - z * vh, h / 2 - z * vh, z * vh * 2, z * vh * 2);//kroužek horizontu událostí
    painter.setPen(QPen(Qt::red, 1));
    for (int i = 0; i < g.getCount(); ++i) {                                    //samotná geodetika
        real x = g.getX(i)[1] * cos(g.getX(i)[3]) * sin(g.getX(i)[2]);
        real y = g.getX(i)[1] * sin(g.getX(i)[3]) * sin(g.getX(i)[2]);
        painter.drawPoint(w / 2 - z * x, h / 2 - z * y);
    }
    painter.end();
    ui->label_geo->setPixmap(pixmap.transformed(QTransform().scale(1, -1)));
    ui->label_geo->show();
}
