#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>

QT_BEGIN_NAMESPACE
namespace Ui { class MainWindow; }
QT_END_NAMESPACE

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = nullptr);
    ~MainWindow();

private slots:
    void on_tt_editingFinished();
    void on_tr_editingFinished();
    void on_te_editingFinished();
    void on_tf_editingFinished();
    void on_rt_editingFinished();
    void on_rr_editingFinished();
    void on_re_editingFinished();
    void on_rf_editingFinished();
    void on_et_editingFinished();
    void on_er_editingFinished();
    void on_ee_editingFinished();
    void on_ef_editingFinished();
    void on_ft_editingFinished();
    void on_fr_editingFinished();
    void on_fe_editingFinished();
    void on_ff_editingFinished();
    void on_lineEdit_a_editingFinished();
    void on_lineEdit_M_editingFinished();
    void on_lineEdit_Q_editingFinished();
    void on_lineEdit_L_editingFinished();
    void on_lineEdit_r_editingFinished();
    void on_lineEdit_th_editingFinished();
    void on_lineEdit_VneH_textChanged(const QString &arg1);
    void on_lineEdit_VniH_textChanged(const QString &arg1);
    void on_tt_textEdited(const QString &arg1);
    void on_tr_textEdited(const QString &arg1);
    void on_te_textEdited(const QString &arg1);
    void on_tf_textEdited(const QString &arg1);
    void on_rt_textEdited(const QString &arg1);
    void on_rr_textEdited(const QString &arg1);
    void on_re_textEdited(const QString &arg1);
    void on_rf_textEdited(const QString &arg1);
    void on_et_textEdited(const QString &arg1);
    void on_er_textEdited(const QString &arg1);
    void on_ee_textEdited(const QString &arg1);
    void on_ef_textEdited(const QString &arg1);
    void on_ft_textEdited(const QString &arg1);
    void on_fr_textEdited(const QString &arg1);
    void on_fe_textEdited(const QString &arg1);
    void on_ff_textEdited(const QString &arg1);
    void on_verticalSlider_sliderReleased();
    void on_StopButton_clicked();
    void on_PlayButton_clicked();
    void on_cBox_precise_currentTextChanged(const QString &arg1);
    void on_OpenImageButton_clicked();
    void on_radButn1_toggled(bool checked);
    void on_radButn2_toggled(bool checked);
    void on_radButn3_toggled(bool checked);
    void on_radButn4_toggled(bool checked);
    void on_radButn5_toggled(bool checked);
    void on_checkBox_anim_stateChanged(int arg1);
    void on_SaveImageButton_clicked();
    void on_horizontalSlider_sliderMoved(int position);
    void on_saveVideoButton_clicked();
    void on_lineEdit_v_textChanged(const QString &arg1);
    void on_spinBox_v_valueChanged(double arg1);
    void on_tabWidget_currentChanged(int index);
    void on_spinBox_round_valueChanged(double arg1);
    void on_lineEdit_inK_editingFinished();
    void on_lineEdit_outK_editingFinished();
    void on_lineEdit_RSO_editingFinished();
    void on_lineEdit_LSO_editingFinished();
    void on_checkBox_kepler_toggled(bool checked);
    void on_comboBox_transp_currentIndexChanged(int index);
    void on_checkBox_sour_toggled(bool checked);

    void recomp(int width, int height);
    void draw_geodetics();
    void reload();
    void pre_v();
    QString corect(QString text);

protected:
    void resizeEvent(QResizeEvent *event) override;

private:
    Ui::MainWindow *ui;
};

void ImgFree(void* buf);
void waitToFreeThread(int numUsedThread);

#endif // MAINWINDOW_H
