#include "postfix.h"                                                            //knihovna pro práci s postfixem

#include "glob_prom.h"                                                          //globální proměnné
#include "numerics.h"

int prior(QChar &ch)                                                            //rozhodování priority operátorů a funkcí
{
    if (ch == 's' || ch == 'c') return 0;
    else if (ch == '^') return 3;
    else if (ch == '/' || ch == '*') return 2;
    else if (ch == '+' || ch == '-') return 1;
    else return -1;
}

QString ToPfx(QString text)                                                     //převod textu na postfix
{
    QString stck;
    QString result;
    if (text[0] == '-') text.prepend('0');
    for (int i = 0; i < text.length(); i++) {
        QChar c = text[i];
        if ((c == 'M') || (c == 'a') || (c == 'Q') || (c == u'Λ') || (c=='t') ||
            (c == 'r') || (c == u'θ') || (c == u'φ') || (c >= '0' && c <= '9'))
            result.append(c);
        else if (c == '(') {stck.append('(');}
        else if (c == 's') {stck.append('s'); i = i + 3;}
        else if (c == 'c') {stck.append('c'); i = i + 3;}
        else if (c == ')'){
            while ((stck.back() != '(') && (stck.back() != 's') &&
                   (stck.back() != 'c')) {
                result.append(stck.back());
                stck.removeLast();
            }
            if (stck.back() == 's') result.append('S');
            else if (stck.back() == 'c') result.append('C');
            stck.removeLast();
        }
        else {
            while (!stck.isEmpty() && prior(text[i]) <= prior(stck.back())) {
                result.append(stck.back());
                stck.removeLast();
            }
            stck.append(c);
        }
    }
    while (!stck.isEmpty()) {result.append(stck.back()); stck.removeLast();}
    return result;
}

tr_pfx TrPfx(QString text)                                                      //překlad postfixu na "strojový kód" pro virtuální procesor
{
    tr_pfx result = {};
    int tl = text.length();
    if (tl == 2 && text[0].unicode() == 48) {} else result.no[4] = true;        //když je obsahem jen 0 nastav příznak nulovosti
    for (int i = 0; i < tl; ++i)
        switch (text[i].unicode()) {
        case 36:  result[i] = 41;                                  break;
        case 42:  result[i] =  0;                                  break;
        case 43:  result[i] =  1;                                  break;
        case 45:  result[i] =  2;                                  break;
        case 47:  result[i] =  3;                                  break;
        case 48:  result[i] =  4;                                  break;
        case 49:  result[i] =  5;                                  break;
        case 50:  result[i] =  6;                                  break;
        case 51:  result[i] =  7;                                  break;
        case 52:  result[i] =  8;                                  break;
        case 53:  result[i] =  9;                                  break;
        case 54:  result[i] = 10;                                  break;
        case 55:  result[i] = 11;                                  break;
        case 56:  result[i] = 12;                                  break;
        case 57:  result[i] = 13;                                  break;
        case 67:  result[i] = 14;                                  break;
        case 77:  result[i] = 15;                                  break;
        case 81:  result[i] = 16;                                  break;
        case 83:  result[i] = 17;                                  break;
        case 94:  result[i] = 18;                                  break;
        case 97:  result[i] = 19;                                  break;
        case 114: result[i] = 20; result.no[1] = true;             break;       //když je v obsahy proměnná r, nastav příznak
        case 116: result[i] = 21; result.no[0] = true;             break;       //když je v obsahy proměnná t, nastav příznak
        case 923: result[i] = 22;                                  break;
        case 952: result[i] = 23; result.no[2] = true;             break;       //když je v obsahy proměnná θ, nastav příznak
        case 966: result[i] = 24; result.no[3] = true;             break;       //když je v obsahy proměnná φ, nastav příznak
        default:  result[i] = text[i].unicode() - char_ofest + 25; break;
        }
    return result;
}

real CntPfx(const uchar (&cmd)[arl], const f_vec &x)                            //virtuální procesor (aritmetický)
{
    static const void *c[] =
      {&&krat, &&plus, &&minus, &&deleno, &&num0, &&num1, &&num2, &&num3,
       &&num4, &&num5, &&num6, &&num7, &&num8, &&num9, &&cos, &&M, &&Q, &&sin,
       &&pow, &&a, &&r, &&t, &&lambda, &&theta, &&fi, &&а, &&б, &&в, &&г, &&д,
       &&е, &&ж, &&з, &&и, &&й, &&к, &&л, &&м, &&н, &&о, &&п, &&ret};
    real s[16]={}, *j = s;                                                      // Ukazatel na vrchol zásobníku
    const uchar *i = cmd;
    const real *k = x.x;
                                                          goto *(*(c + *(i++)));
krat:     *(j - 1) *= *(--j);                             goto *(*(c + *(i++)));
plus:     *(j - 1) += *(--j);                             goto *(*(c + *(i++)));
minus:    if (j - s) *(j-1) -= *(--j); else *(j-1) *= -1; goto *(*(c + *(i++)));
deleno:   *(j - 1) /= *(--j);                             goto *(*(c + *(i++)));
num0:     *( j++ ) = 0.;                                  goto *(*(c + *(i++)));
num1:     *( j++ ) = 1.;                                  goto *(*(c + *(i++)));
num2:     *( j++ ) = 2.;                                  goto *(*(c + *(i++)));
num3:     *( j++ ) = 3.;                                  goto *(*(c + *(i++)));
num4:     *( j++ ) = 4.;                                  goto *(*(c + *(i++)));
num5:     *( j++ ) = 5.;                                  goto *(*(c + *(i++)));
num6:     *( j++ ) = 6.;                                  goto *(*(c + *(i++)));
num7:     *( j++ ) = 7.;                                  goto *(*(c + *(i++)));
num8:     *( j++ ) = 8.;                                  goto *(*(c + *(i++)));
num9:     *( j++ ) = 9.;                                  goto *(*(c + *(i++)));
cos:      *(j - 1) = cos(*(j - 1));                       goto *(*(c + *(i++)));
M:        *( j++ ) = P.M;                                 goto *(*(c + *(i++)));
Q:        *( j++ ) = P.Q;                                 goto *(*(c + *(i++)));
sin:      *(j - 1) = sin(*(j - 1));                       goto *(*(c + *(i++)));
pow: --j; *(j - 1) = pw(*(j - 1), *(j));                  goto *(*(c + *(i++)));
a:        *( j++ ) = P.a;                                 goto *(*(c + *(i++)));
r:        *( j++ ) = *(k + 1);                            goto *(*(c + *(i++)));
t:        *( j++ ) = *(k);                                goto *(*(c + *(i++)));
lambda:   *( j++ ) = P.Λ;                                 goto *(*(c + *(i++)));
theta:    *( j++ ) = *(k + 2);                            goto *(*(c + *(i++)));
fi:       *( j++ ) = *(k + 3);                            goto *(*(c + *(i++)));
а:        *( j++ ) = *(s);                                goto *(*(c + *(i++)));
б:        *( j++ ) = *(s + 1);                            goto *(*(c + *(i++)));
в:        *( j++ ) = *(s + 2);                            goto *(*(c + *(i++)));
г:        *( j++ ) = *(s + 3);                            goto *(*(c + *(i++)));
д:        *( j++ ) = *(s + 4);                            goto *(*(c + *(i++)));
е:        *( j++ ) = *(s + 5);                            goto *(*(c + *(i++)));
ж:        *( j++ ) = *(s + 6);                            goto *(*(c + *(i++)));
з:        *( j++ ) = *(s + 7);                            goto *(*(c + *(i++)));
и:        *( j++ ) = *(s + 8);                            goto *(*(c + *(i++)));
й:        *( j++ ) = *(s + 9);                            goto *(*(c + *(i++)));
к:        *( j++ ) = *(s + 10);                           goto *(*(c + *(i++)));
л:        *( j++ ) = *(s + 11);                           goto *(*(c + *(i++)));
м:        *( j++ ) = *(s + 12);                           goto *(*(c + *(i++)));
н:        *( j++ ) = *(s + 13);                           goto *(*(c + *(i++)));
о:        *( j++ ) = *(s + 14);                           goto *(*(c + *(i++)));
п:        *( j++ ) = *(s + 15);                           goto *(*(c + *(i++)));
ret:      return *(--j);                                                        //$
}

QString SimpPfx(QString &text)                                                  //zjednodušení výrazu postfixu
{
    int len;
    do {
        len = text.length();
        QString st[len];
        for (int i = 0, j = 0; i < len; ++i) {
            int c = text[i].unicode();
            switch (c) {
            case 42:                                                            //*
            {
                if (st[j-2] == '0' || st[j-1] == '1');
                else if (st[j-1] == '0') st[j-2] = '0';
                else if (st[j-2].front().unicode() < st[j-1].front().unicode())
                    st[j-2] = st[j-2].append(st[j-1].append('*'));
                else st[j-2] = st[j-1].append(st[j-2].append('*'));
                j--;
            } break;
            case 43:                                                            //+
            {
                if (st[j-2] == '0') st[j-2] = st[j-1];
                else if (st[j-1] == '0');
                else if (st[j-2].front().unicode() < st[j-1].front().unicode())
                    st[j-2] = st[j-2].append(st[j-1].append('+'));
                else st[j-2] = st[j-1].append(st[j-2].append('+'));
                j--;
            } break;
            case 45:                                                            //-
            {
                if (j == 1)
                    if (st[j-1] == '0');
                    else st[j-1] = st[j-1].append('-');
                else
                {
                    if (st[j-2] == st[j-1]) st[j-2] = '0';
                    else if (st[j-1] == '0');
                    else st[j-2] = st[j-2].append(st[j-1].append('-'));
                    j--;
                } break;
            }
            case 47:                                                            //
            {
                if (st[j-2] == st[j-1]) st[j-2] = '1';
                else if (st[j-2] == '0');
                else if (st[j-1] == '1');
                else st[j-2] = st[j-2].append(st[j-1].append('/'));
                j--;
            } break;
            case 67: st[j-1] = st[j-1].append('C'); break;                      //cos
            case 77: st[j++] = 'M'; break;                                      //M
            case 81: st[j++] = 'Q'; break;                                      //Q
            case 83: st[j-1] = st[j-1].append('S'); break;                      //sin
            case 94:                                                            //^
            {
                if (st[j-2] == '0');
                else if (st[j-1] == '1');
                else st[j-2] = st[j-2].append(st[j-1].append('^'));
                j--;
            } break;
            case 97:  st[j++] = 'a'; break;                                     //a
            case 114: st[j++] = 'r'; break;                                     //r
            case 116: st[j++] = 't'; break;                                     //t
            case 923: st[j++] = u'Λ'; break;                                    //Λ
            case 952: st[j++] = u'θ'; break;                                    //θ
            case 966: st[j++] = u'φ'; break;                                    //φ
            default:  st[j++] = text[i]; break;                                 //num
            }
        }
        text = st[0];
    } while (len > text.length());
    return text;
}


bool valPfx(QString text)                                                       //zjištění, zda řetězec je validní postfix
{
    int j = 0;
    for (int i = 0; i < text.length(); ++i) {
        int c = text[i].unicode();
        switch (c) {
        case  42: --j; break;//*
        case  43: --j; break;//+
        case  45: --j; break;//-
        case  47: --j; break;//
        case  67:      break;//cos
        case  83:      break;//sin
        case  94: --j; break;//^
        default : ++j; break;
        }
        if (j > 10 || j < 1) break;
    }
    return (j == 1);
}

QString MaxRepStr(QString &text)                                                //hledání nejdelších opakujících se validních subpostfixů
{
    QString maxStr;
    int max = 0;
    int l = text.length();
    for (int a = 0; a < l; ++a)
        for (int b = 3; b < l - a; ++b){
            QString sub = text.mid(a,b);
            if (valPfx(sub) && max <= text.count(sub)) {
                max = text.count(sub);
                maxStr = sub;
            }
        }
    return  maxStr;
}

QString OptPfx(QString &text)                                                   //budování stromové struktury z opakujících se subpostfixů
{
    int rep;
    QString maxStr[16], result = {};
    if (text.length() > 3) {
        text = SimpPfx(text);
        if (text.length() > 3) {
            int p = -1;
            do{
                maxStr[++p] = MaxRepStr(text);
                rep = text.count(maxStr[p]);
                if (rep > 1) {
                    text.replace(maxStr[p],QChar(char_ofest + p));
                    text = SimpPfx(text);
                }
            } while (rep > 1);
            for (int i = 0; i < p; ++i)
                result += maxStr[i];
        }
    };
    return result + text + '$';
}
